/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.ashley.utils;

public class Bag<E> {
    private E[] data;
    private int size = 0;

    public Bag() {
        this(64);
    }

    public Bag(int capacity) {
        this.data = new Object[capacity];
    }

    public E remove(int index) {
        E e = this.data[index];
        this.data[index] = this.data[--this.size];
        this.data[this.size] = null;
        return e;
    }

    public E removeLast() {
        if (this.size > 0) {
            E e = this.data[--this.size];
            this.data[this.size] = null;
            return e;
        }
        return null;
    }

    public boolean remove(E e) {
        for (int i = 0; i < this.size; ++i) {
            E e2 = this.data[i];
            if (e != e2) continue;
            this.data[i] = this.data[--this.size];
            this.data[this.size] = null;
            return true;
        }
        return false;
    }

    public boolean contains(E e) {
        for (int i = 0; this.size > i; ++i) {
            if (e != this.data[i]) continue;
            return true;
        }
        return false;
    }

    public E get(int index) {
        return this.data[index];
    }

    public int size() {
        return this.size;
    }

    public int getCapacity() {
        return this.data.length;
    }

    public boolean isIndexWithinBounds(int index) {
        return index < this.getCapacity();
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void add(E e) {
        if (this.size == this.data.length) {
            this.grow();
        }
        this.data[this.size++] = e;
    }

    public void set(int index, E e) {
        if (index >= this.data.length) {
            this.grow(index * 2);
        }
        this.size = Math.max(this.size, index + 1);
        this.data[index] = e;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = null;
        }
        this.size = 0;
    }

    private void grow() {
        int newCapacity = this.data.length * 3 / 2 + 1;
        this.grow(newCapacity);
    }

    private void grow(int newCapacity) {
        E[] oldData = this.data;
        this.data = new Object[newCapacity];
        System.arraycopy(oldData, 0, this.data, 0, oldData.length);
    }
}

