/*
 * Decompiled with CFR 0.152.
 */
package com.eng1.game.assets.skins;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.eng1.game.assets.Assets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public enum SkinAssets implements Assets<Skin>
{
    UI(() -> new Skin(Gdx.files.internal("skin/uiskin.json")));

    private final List<Skin> loadedSkins = new ArrayList<Skin>();
    private final Supplier<Skin> skin;

    private SkinAssets(Supplier<Skin> skin) {
        this.skin = skin;
    }

    @Override
    public Skin get() {
        Skin skin = this.skin.get();
        this.loadedSkins.add(skin);
        return skin;
    }

    @Override
    public void dispose() {
        for (Skin skin : this.loadedSkins) {
            skin.dispose();
        }
        this.loadedSkins.clear();
    }

    @Override
    public void dispose(@NotNull Skin asset) {
        asset.dispose();
        this.loadedSkins.remove(asset);
    }

    public static void disposeAll() {
        for (SkinAssets asset : SkinAssets.values()) {
            asset.dispose();
        }
    }
}

