/*
 * Decompiled with CFR 0.152.
 */
package com.eng1.game.audio.music;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import org.jetbrains.annotations.Range;

public abstract class GameMusic
implements Music {
    protected final Music music;

    protected GameMusic(String path) {
        this.music = Gdx.audio.newMusic(Gdx.files.internal(path));
    }

    @Override
    public void play() {
        this.music.play();
    }

    @Override
    public void pause() {
        this.music.pause();
    }

    @Override
    public void stop() {
        this.music.stop();
    }

    @Override
    public boolean isPlaying() {
        return this.music.isPlaying();
    }

    @Override
    public void setLooping(boolean isLooping) {
        this.music.setLooping(isLooping);
    }

    @Override
    public boolean isLooping() {
        return this.music.isLooping();
    }

    @Override
    public void setVolume(@Range(from=0L, to=1L) float volume) {
        this.music.setVolume(volume);
    }

    @Override
    public @Range(from=0L, to=1L) float getVolume() {
        return this.music.getVolume();
    }

    @Override
    public void setPan(@Range(from=-1L, to=1L) float pan, @Range(from=0L, to=1L) float volume) {
        this.music.setPan(pan, volume);
    }

    @Override
    public void dispose() {
        this.music.dispose();
    }

    @Override
    public void setPosition(float position) {
        this.music.setPosition(position);
    }

    @Override
    public float getPosition() {
        return this.music.getPosition();
    }

    @Override
    public void setOnCompletionListener(Music.OnCompletionListener listener) {
        this.music.setOnCompletionListener(listener);
    }

    public Music getMusic() {
        return this.music;
    }
}

