/*
 * Decompiled with CFR 0.152.
 */
package com.eng1.game.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Json;
import com.eng1.game.game.achievement.Achievements;
import com.eng1.game.game.player.Statistics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Score {
    private static final String SCORE_FILE = "scores.json";
    private static final Json json = new Json();

    @Contract(pure=true)
    @NotNull
    public static String getClassification(float scorePercentage) {
        if (scorePercentage < 40.0f) {
            return "Fail";
        }
        if (scorePercentage >= 40.0f && scorePercentage < 50.0f) {
            return "Third Class";
        }
        if (scorePercentage >= 50.0f && scorePercentage < 60.0f) {
            return "Lower Second Class";
        }
        if (scorePercentage >= 60.0f && scorePercentage < 70.0f) {
            return "Upper Second Class";
        }
        if (scorePercentage >= 70.0f && scorePercentage < 80.0f) {
            return "First Class";
        }
        return "First Class with Distinction";
    }

    @NotNull
    public static List<ScoreEntry> getTop10Scores() {
        ArrayList scores = new ArrayList();
        FileHandle file = Gdx.files.local(SCORE_FILE);
        if (file.exists()) {
            scores = json.fromJson(ArrayList.class, ScoreEntry.class, file);
        } else {
            System.out.println("File does not exist: scores.json");
        }
        scores.sort(Comparator.comparingDouble(ScoreEntry::getScore).reversed());
        return scores.size() > 10 ? scores.subList(0, 10) : scores;
    }

    public static int getLastScore() {
        List<ScoreEntry> topScores = Score.getTop10Scores();
        if (topScores.size() < 10) {
            return 0;
        }
        return topScores.get(topScores.size() - 1).getScore();
    }

    public static void saveScore(String playerName, int scorePercentage) {
        List<ScoreEntry> scores = Score.getTop10Scores();
        scores.add(new ScoreEntry(playerName, scorePercentage));
        scores.sort(Comparator.comparingDouble(ScoreEntry::getScore).reversed());
        FileHandle file = Gdx.files.local(SCORE_FILE);
        file.writeString(json.prettyPrint(scores), false);
    }

    public static int calculateScorePercentage() {
        Achievements[] achievements;
        float scoreTotal = Arrays.stream(Statistics.PlayerStatistics.values()).map(Statistics.PlayerStatistics::getTotal).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
        float maxTotal = Statistics.MAX_SCORE;
        float score = scoreTotal / maxTotal * 0.8f;
        for (Achievements achievement : achievements = Achievements.values()) {
            if (!achievement.hasAchieved()) continue;
            score += achievement.getScore() / 100.0f;
        }
        score = Math.min(score, 1.0f);
        return (int)Math.floor(score * 100.0f);
    }

    private Score() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class ScoreEntry {
        private final String playerName;
        private final int score;

        public ScoreEntry() {
            this("", 0);
        }

        public ScoreEntry(String playerName, int score) {
            this.playerName = playerName;
            this.score = score;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public int getScore() {
            return this.score;
        }
    }
}

