/*
 * Decompiled with CFR 0.152.
 */
package com.eng1.game.game.achievement;

import com.eng1.game.game.achievement.Achievement;
import com.eng1.game.game.achievement.DreamweaverAchievement;
import com.eng1.game.game.achievement.FitnessFanaticAchievement;
import com.eng1.game.game.achievement.ScholarlySprinterAchievement;
import com.eng1.game.game.achievement.SnackMasterAchievement;
import com.eng1.game.game.achievement.SocialButterflyAchievement;
import com.eng1.game.game.achievement.TeachersPetAchievement;
import com.eng1.game.game.achievement.WellRoundedAchievement;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public enum Achievements {
    FITNESS_FANATIC(new FitnessFanaticAchievement(), 4.0f, "Active at least 3 times in the week"),
    DREAMWEAVER(new DreamweaverAchievement(), 2.0f, "Daydreamed more than 4 times in the week"),
    SNACK_MASTER(new SnackMasterAchievement(), 1.0f, "Snacked 5 out of 7 days in the week"),
    SCHOLARLY_SPRINTER(new ScholarlySprinterAchievement(), 6.0f, "Studying once every day in the week"),
    WELL_ROUNDED(new WellRoundedAchievement(), 2.0f, "Participated in all activities in the week"),
    TEACHERS_PET(new TeachersPetAchievement(), 3.0f, "Went to teaching hours more than twice in a week"),
    SOCIAL_BUTTERFLY(new SocialButterflyAchievement(), 2.0f, "Socialized with friends at least 3 times in the week");

    private final float score;
    private final String description;
    private final Achievement achievementRef;

    private Achievements(Achievement achievementRef, float addScorePercent, String description) {
        this.achievementRef = achievementRef;
        this.score = addScorePercent;
        this.description = description;
    }

    public String getName() {
        return Arrays.stream(this.name().split("_")).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase()).reduce((s1, s2) -> s1 + " " + s2).orElse("");
    }

    public boolean hasAchieved() {
        return this.achievementRef.hasAchieved();
    }

    @Nullable
    public static Achievements fromString(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        for (Achievements achievement : Achievements.values()) {
            if (!achievement.name().equalsIgnoreCase(string)) continue;
            return achievement;
        }
        return null;
    }

    public float getScore() {
        return this.score;
    }

    public String getDescription() {
        return this.description;
    }

    public Achievement getAchievementRef() {
        return this.achievementRef;
    }
}

