/*
 * Decompiled with CFR 0.152.
 */
package com.eng1.game.game.achievement;

import com.eng1.game.game.achievement.Achievement;
import com.eng1.game.game.activity.Activities;
import java.util.HashMap;
import java.util.HashSet;

public class WellRoundedAchievement
implements Achievement {
    private final HashMap<Integer, HashSet<Activities>> daysActivities = new HashMap();

    @Override
    public boolean hasAchieved() {
        int activitiesLength = Activities.values().length;
        return this.getDaysActivities() >= 7 && this.daysActivities.values().stream().mapToInt(HashSet::size).allMatch(size -> size == activitiesLength);
    }

    public void addActivity(int day, Activities activity) {
        this.daysActivities.computeIfAbsent(day, d -> new HashSet()).add(activity);
    }

    public void reset() {
        this.daysActivities.clear();
    }

    public int getDaysActivities() {
        return this.daysActivities.size();
    }

    public int getDaysActivities(int day) {
        return this.daysActivities.get(day).size();
    }
}

