/*
 * Decompiled with CFR 0.152.
 */
package com.eng1.game.game.activity;

import com.eng1.game.game.player.Statistics;
import com.eng1.game.utils.Pair;
import org.jetbrains.annotations.Nullable;

public enum Activities {
    STUDY(Pair.of(Statistics.PlayerStatistics.STUDY, Statistics.Effect.INCREASE), Pair.of(Statistics.PlayerStatistics.ENERGY, Statistics.Effect.DECREASE), Pair.of(Statistics.PlayerStatistics.HAPPINESS, Statistics.Effect.DECREASE)),
    SLEEP(Pair.of(Statistics.PlayerStatistics.ENERGY, Statistics.Effect.RESET), Pair.of(Statistics.PlayerStatistics.STUDY, Statistics.Effect.RESET)),
    NAP(Pair.of(Statistics.PlayerStatistics.ENERGY, Statistics.Effect.INCREASE)),
    EAT(Pair.of(Statistics.PlayerStatistics.ENERGY, Statistics.Effect.INCREASE)),
    RELAX(Pair.of(Statistics.PlayerStatistics.ENERGY, Statistics.Effect.DECREASE), Pair.of(Statistics.PlayerStatistics.HAPPINESS, Statistics.Effect.INCREASE));

    private final Pair<Statistics.PlayerStatistics, Statistics.Effect>[] effects;

    @SafeVarargs
    private Activities(Pair<Statistics.PlayerStatistics, Statistics.Effect> ... effects) {
        this.effects = effects;
    }

    @Nullable
    public static Activities fromString(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        for (Activities activity : Activities.values()) {
            if (!activity.name().equalsIgnoreCase(string)) continue;
            return activity;
        }
        return null;
    }

    @Nullable
    public Statistics.Effect getEffect(Statistics.PlayerStatistics statistic) {
        for (Pair<Statistics.PlayerStatistics, Statistics.Effect> effect : this.effects) {
            if (!effect.getLeft().equals(statistic)) continue;
            return effect.getRight();
        }
        return null;
    }

    public int indexOf(Statistics.PlayerStatistics statistic) {
        for (int i = 0; i < this.effects.length; ++i) {
            if (!this.effects[i].getLeft().equals(statistic)) continue;
            return i;
        }
        return -1;
    }

    public Pair<Statistics.PlayerStatistics, Statistics.Effect>[] getEffects() {
        return this.effects;
    }
}

