/*
 * Decompiled with CFR 0.152.
 */
package com.eng1.game.game.player;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.maps.MapObjects;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.eng1.game.assets.maps.MapAssets;
import com.eng1.game.assets.skins.SkinAssets;
import com.eng1.game.game.achievement.Achievement;
import com.eng1.game.game.achievement.Achievements;
import com.eng1.game.game.achievement.DreamweaverAchievement;
import com.eng1.game.game.achievement.FitnessFanaticAchievement;
import com.eng1.game.game.achievement.ScholarlySprinterAchievement;
import com.eng1.game.game.achievement.SnackMasterAchievement;
import com.eng1.game.game.achievement.SocialButterflyAchievement;
import com.eng1.game.game.achievement.TeachersPetAchievement;
import com.eng1.game.game.achievement.WellRoundedAchievement;
import com.eng1.game.game.activity.Activities;
import com.eng1.game.game.activity.ActivityMapObject;
import com.eng1.game.game.player.Statistics;
import com.eng1.game.screens.PlayScreen;
import com.eng1.game.screens.Screens;
import com.eng1.game.utils.Pair;
import java.lang.invoke.LambdaMetafactory;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class Player
extends Sprite
implements InputProcessor {
    private static final Skin uiSkin = SkinAssets.UI.get();
    private final Vector2 velocity = new Vector2();
    private float speed = 300.0f;
    private final TiledMapTileLayer collisionLayer;
    private final MapLayer transitionLayer;
    private final MapLayer activityLayer;
    private ActivityMapObject potentialActivity = null;
    private List<Statistics.PlayerStatistics> canDoActivity = null;

    public Player(Sprite sprite, TiledMapTileLayer collisionLayer, MapLayer transitionLayer, MapLayer activityLayer) {
        super(sprite);
        this.collisionLayer = collisionLayer;
        this.transitionLayer = transitionLayer;
        this.activityLayer = activityLayer;
        this.setScale(3.0f);
    }

    /*
     * Unable to fully structure code
     */
    public void drawHud(Batch batch) {
        block5: {
            if (this.potentialActivity == null || this.canDoActivity == null) break block5;
            if (this.potentialActivity.getActivity().equals((Object)Activities.SLEEP)) ** GOTO lbl-1000
            if (Statistics.isEndOfDay()) {
                label = new Label((CharSequence)"It's time to sleep!", Player.uiSkin);
            } else if (!this.hasTimeForActivity()) {
                label = new Label((CharSequence)("It's too late to " + this.potentialActivity.getText()), Player.uiSkin);
            } else lbl-1000:
            // 2 sources

            {
                label = this.canDoActivity.isEmpty() != false ? new Label((CharSequence)("Press E to " + this.potentialActivity.getText()), Player.uiSkin) : new Label((CharSequence)("Not enough " + this.canDoActivity.stream().map((Function<Statistics.PlayerStatistics, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getLabel(), (Lcom/eng1/game/game/player/Statistics$PlayerStatistics;)Ljava/lang/String;)()).collect(Collectors.joining(", "))), Player.uiSkin);
            }
            label.setPosition((float)Gdx.graphics.getWidth() / 2.0f - label.getWidth() / 2.0f, 0.0f);
            label.draw(batch, 1.0f);
        }
        statistics = Statistics.PlayerStatistics.values();
        for (i = 0; i < statistics.length; ++i) {
            statistic = statistics[i];
            progressBar = statistic.getProgressBar();
            progressBar.updateVisualValue();
            label = new Label((CharSequence)(statistic.getLabel() + ": " + (int)(statistic.get() * 100.0f) + "%"), Player.uiSkin);
            yPos = (float)i * (progressBar.getHeight() + 10.0f);
            progressBar.setPosition((float)Gdx.graphics.getWidth() - progressBar.getWidth(), yPos);
            label.setPosition((float)Gdx.graphics.getWidth() - progressBar.getWidth(), yPos + progressBar.getHeight());
            progressBar.draw(batch, 1.0f);
            label.draw(batch, 1.0f);
        }
    }

    public void update(float delta) {
        ActivityMapObject cellActivity;
        Pair<MapAssets, String> cellTransition;
        float oldX = this.getX();
        float oldY = this.getY();
        boolean collisionX = false;
        boolean collisionY = false;
        this.setX(this.getX() + this.velocity.x * delta);
        if (this.velocity.x != 0.0f) {
            collisionX = this.collidesHorizontal();
        }
        if (collisionX) {
            this.setX(oldX);
            this.velocity.x = 0.0f;
        }
        this.setY(this.getY() + this.velocity.y * delta);
        if (this.velocity.y != 0.0f) {
            collisionY = this.collidesVertical();
        }
        if (collisionY) {
            this.setY(oldY);
            this.velocity.y = 0.0f;
        }
        if ((cellTransition = this.getCellTransition(this.getX(), this.getY())) != null) {
            PlayScreen screen = (PlayScreen)Screens.PLAY.get();
            screen.changeMap(cellTransition.getLeft(), cellTransition.getRight());
        }
        this.potentialActivity = cellActivity = this.getCellActivity(this.getX(), this.getY());
        this.canDoActivity = cellActivity == null ? null : this.canDoActivity();
    }

    @Override
    public boolean keyDown(int keycode) {
        switch (keycode) {
            case 19: 
            case 51: {
                this.velocity.y = this.speed;
                break;
            }
            case 21: 
            case 29: {
                this.velocity.x = -this.speed;
                break;
            }
            case 20: 
            case 47: {
                this.velocity.y = -this.speed;
                break;
            }
            case 22: 
            case 32: {
                this.velocity.x = this.speed;
                break;
            }
            case 33: {
                if (this.potentialActivity == null || this.canDoActivity == null || !this.canDoActivity.isEmpty() || !this.potentialActivity.getActivity().equals((Object)Activities.SLEEP) && (Statistics.isEndOfDay() || !this.hasTimeForActivity())) break;
                this.doActivity();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean hasTimeForActivity() {
        if (this.potentialActivity == null) {
            return false;
        }
        if (this.potentialActivity.getActivity().equals((Object)Activities.SLEEP)) {
            return true;
        }
        if (Statistics.isEndOfDay()) {
            return false;
        }
        ActivityMapObject activity = this.potentialActivity;
        LocalTime time = Statistics.getTime();
        LocalTime dayEnd = Statistics.DAY_END;
        int hoursBeforeEnd = dayEnd.getHour() - time.getHour();
        return hoursBeforeEnd >= activity.getAdvanceTimeBy();
    }

    @Nullable
    private List<Statistics.PlayerStatistics> canDoActivity() {
        if (this.potentialActivity == null) {
            return null;
        }
        ActivityMapObject activity = Objects.requireNonNull(this.potentialActivity);
        Activities activityRef = activity.getActivity();
        List<Float> changeStats = activity.getChangeStats();
        ArrayList<Statistics.PlayerStatistics> notEnough = new ArrayList<Statistics.PlayerStatistics>();
        Pair<Statistics.PlayerStatistics, Statistics.Effect>[] effects = activityRef.getEffects();
        for (int i = 0; i < effects.length; ++i) {
            Pair<Statistics.PlayerStatistics, Statistics.Effect> effect = effects[i];
            Statistics.PlayerStatistics statistic = effect.getLeft();
            Statistics.Effect effectType = effect.getRight();
            float change = changeStats.get(i).floatValue();
            if (!effectType.equals((Object)Statistics.Effect.DECREASE) || !(statistic.get() - change < 0.0f)) continue;
            notEnough.add(statistic);
        }
        return notEnough;
    }

    private void doActivity() {
        if (this.potentialActivity == null) {
            return;
        }
        ActivityMapObject activity = this.potentialActivity;
        Activities activityRef = activity.getActivity();
        List<Float> changeStats = activity.getChangeStats();
        Pair<Statistics.PlayerStatistics, Statistics.Effect>[] effects = activityRef.getEffects();
        block5: for (int i = 0; i < effects.length; ++i) {
            Pair<Statistics.PlayerStatistics, Statistics.Effect> effect = effects[i];
            Statistics.PlayerStatistics statistic = effect.getLeft();
            Statistics.Effect effectType = effect.getRight();
            float change = changeStats.get(i).floatValue();
            switch (effectType) {
                case INCREASE: {
                    statistic.increase(change);
                    continue block5;
                }
                case DECREASE: {
                    statistic.decrease(change);
                    continue block5;
                }
                case RESET: {
                    statistic.reset();
                }
            }
        }
        if (activityRef.equals((Object)Activities.SLEEP)) {
            for (Statistics.PlayerStatistics statistic : Statistics.PlayerStatistics.values()) {
                statistic.increaseTotal(statistic.get());
            }
            if (Statistics.isEndOfDays()) {
                Screens.END.setAsCurrent();
            } else {
                Statistics.newDay();
            }
        } else {
            Statistics.increaseTime(LocalTime.of(activity.getAdvanceTimeBy(), 0));
        }
        List<Achievements> achievements = activity.getAchievements();
        if (!achievements.isEmpty()) {
            for (Achievements achievement : achievements) {
                Achievement achievementRef = achievement.getAchievementRef();
                if (achievementRef instanceof DreamweaverAchievement) {
                    DreamweaverAchievement dreamweaverAchievement = (DreamweaverAchievement)achievementRef;
                    dreamweaverAchievement.daydream();
                    continue;
                }
                if (achievementRef instanceof FitnessFanaticAchievement) {
                    FitnessFanaticAchievement fitnessFanaticAchievement = (FitnessFanaticAchievement)achievementRef;
                    fitnessFanaticAchievement.exercise();
                    continue;
                }
                if (achievementRef instanceof ScholarlySprinterAchievement) {
                    ScholarlySprinterAchievement scholarlySprinterAchievement = (ScholarlySprinterAchievement)achievementRef;
                    scholarlySprinterAchievement.study(Statistics.getDay());
                    continue;
                }
                if (achievementRef instanceof SnackMasterAchievement) {
                    SnackMasterAchievement snackMasterAchievement = (SnackMasterAchievement)achievementRef;
                    snackMasterAchievement.snack();
                    continue;
                }
                if (achievementRef instanceof SocialButterflyAchievement) {
                    SocialButterflyAchievement socialButterflyAchievement = (SocialButterflyAchievement)achievementRef;
                    socialButterflyAchievement.socialise();
                    continue;
                }
                if (achievementRef instanceof TeachersPetAchievement) {
                    TeachersPetAchievement teachersPetAchievement = (TeachersPetAchievement)achievementRef;
                    teachersPetAchievement.attendTeachingHours();
                    continue;
                }
                if (!(achievementRef instanceof WellRoundedAchievement)) continue;
                WellRoundedAchievement wellRoundedAchievement = (WellRoundedAchievement)achievementRef;
                wellRoundedAchievement.addActivity(Statistics.getDay(), activityRef);
            }
        }
    }

    @Override
    public boolean keyUp(int keycode) {
        switch (keycode) {
            case 19: 
            case 20: 
            case 47: 
            case 51: {
                this.velocity.y = 0.0f;
                break;
            }
            case 21: 
            case 22: 
            case 29: 
            case 32: {
                this.velocity.x = 0.0f;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean isCellBlocked(float x, float y) {
        TiledMapTileLayer.Cell cell = this.collisionLayer.getCell((int)(x / (float)this.collisionLayer.getTileWidth()), (int)(y / (float)this.collisionLayer.getTileHeight()));
        String blockedKey = "blocked";
        if (cell == null) {
            return false;
        }
        TiledMapTile tile = cell.getTile();
        return tile != null && tile.getProperties().containsKey(blockedKey);
    }

    private boolean collidesHorizontal() {
        for (float step = 0.0f; step < this.getHeight(); step += (float)this.collisionLayer.getTileHeight() / 2.0f) {
            if (!this.isCellBlocked(this.getX() + this.getWidth(), this.getY() + step)) continue;
            return true;
        }
        return false;
    }

    private boolean collidesVertical() {
        for (float step = 0.0f; step < this.getWidth(); step += (float)this.collisionLayer.getTileWidth() / 2.0f) {
            if (!this.isCellBlocked(this.getX() + this.getWidth(), this.getY() + step)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private @Nullable Pair<MapAssets, @Nullable String> getCellTransition(float x, float y) {
        MapObjects objects = this.transitionLayer.getObjects();
        for (int i = 0; i < objects.getCount(); ++i) {
            MapObject mapObject = objects.get(i);
            MapProperties properties = mapObject.getProperties();
            float x1 = properties.get("x", Float.TYPE).floatValue();
            float y2 = properties.get("y", Float.TYPE).floatValue();
            float width = properties.get("width", Float.TYPE).floatValue();
            float height = properties.get("height", Float.TYPE).floatValue();
            if (!(x >= x1) || !(x <= x1 + width) || !(y >= y2) || !(y <= y2 + height)) continue;
            return Pair.of(MapAssets.valueOf(properties.get("map_id", String.class)), properties.get("spawnpoint", String.class));
        }
        return null;
    }

    @Nullable
    private ActivityMapObject getCellActivity(float x, float y) {
        MapObjects objects = this.activityLayer.getObjects();
        for (int i = 0; i < objects.getCount(); ++i) {
            Boolean isActivity;
            MapObject mapObject = objects.get(i);
            MapProperties properties = mapObject.getProperties();
            float x1 = properties.get("x", Float.TYPE).floatValue();
            float y2 = properties.get("y", Float.TYPE).floatValue();
            float width = properties.get("width", Float.TYPE).floatValue();
            float height = properties.get("height", Float.TYPE).floatValue();
            if (!(x >= x1 && x <= x1 + width && y >= y2 && y <= y2 + height && Boolean.TRUE.equals(isActivity = properties.get("is_activity", Boolean.class)))) continue;
            return ActivityMapObject.fromMapObject(mapObject);
        }
        return null;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchCancelled(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean scrolled(float amountX, float amountY) {
        return false;
    }

    @Override
    public void setSize(float width, float height) {
        super.setSize(width, height);
        this.setScale(3.0f);
    }

    public void dispose() {
        uiSkin.dispose();
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getSpeed() {
        return this.speed;
    }

    public TiledMapTileLayer getCollisionLayer() {
        return this.collisionLayer;
    }
}

