/*
 * Decompiled with CFR 0.152.
 */
package com.eng1.game.game.player;

import com.badlogic.gdx.scenes.scene2d.ui.ProgressBar;
import com.eng1.game.game.player.PlayerStatistic;
import java.time.LocalTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class Statistics {
    @Deprecated(forRemoval=true)
    private static int score = 0;
    public static final int MAX_DAYS = 7;
    public static final int MAX_SCORE = PlayerStatistics.getMaxScorePerDay() * 7;
    private static int day = 1;
    private static LocalTime time = LocalTime.of(7, 0);
    public static final LocalTime DAY_START = LocalTime.of(7, 0);
    public static final LocalTime DAY_END = LocalTime.of(23, 0);

    public static void newDay() {
        time = DAY_START;
        ++day;
    }

    public static boolean isEndOfDay() {
        return time.equals(DAY_END);
    }

    public static boolean isEndOfDays() {
        return day == 7;
    }

    public static void increaseTime(@NotNull LocalTime time) {
        Statistics.time = Statistics.time.plusHours(time.getHour());
        Statistics.time = Statistics.time.plusMinutes(time.getMinute());
    }

    @Deprecated(forRemoval=true)
    public static void increaseScore(int score) {
        Statistics.score += score;
    }

    public static void dispose() {
        PlayerStatistic.dispose();
    }

    private Statistics() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Deprecated
    public static int getScore() {
        return score;
    }

    public static int getDay() {
        return day;
    }

    public static LocalTime getTime() {
        return time;
    }

    public static enum PlayerStatistics implements PlayerStatistic
    {
        ENERGY("Energy", 0.5f),
        HAPPINESS("Happiness", 0.5f),
        STUDY("Study Level", 0.0f);

        private final ProgressBar progressBar = new ProgressBar(0.0f, 1.0f, 0.1f, false, uiSkin);
        private final String label;
        private final float defaultValue;
        private @Range(from=0L, to=1L) float value;
        private float total = 0.0f;

        private PlayerStatistics(String label, float defaultValue) {
            this.label = label;
            this.defaultValue = defaultValue;
            this.value = defaultValue;
            this.progressBar.setValue(defaultValue);
            this.progressBar.setWidth(200.0f);
            this.progressBar.setHeight(50.0f);
            this.progressBar.setAnimateDuration(0.25f);
            this.progressBar.setRound(false);
        }

        @Override
        public float get() {
            return this.value;
        }

        @Override
        public void set(@Range(from=0L, to=1L) float value) {
            this.value = value;
            this.progressBar.setValue(Math.max(0.0f, Math.min(1.0f, value)));
        }

        @Override
        public void increase(float amount) {
            this.set(Math.min(1.0f, this.value + amount));
        }

        @Override
        public void decrease(float amount) {
            this.set(Math.max(0.0f, this.value - amount));
        }

        @Override
        public float getDefault() {
            return this.defaultValue;
        }

        @Override
        public void setTotal(float total) {
            this.total = total;
        }

        @Override
        public void increaseTotal(float amount) {
            this.total += amount;
        }

        @Override
        public float getTotal() {
            return this.total;
        }

        @Override
        public float getMaxTotal() {
            return 7.0f;
        }

        @Override
        public void reset() {
            this.set(this.getDefault());
        }

        public static int getMaxScorePerDay() {
            return PlayerStatistics.values().length;
        }

        @Override
        public ProgressBar getProgressBar() {
            return this.progressBar;
        }

        @Override
        public String getLabel() {
            return this.label;
        }
    }

    public static enum Effect {
        INCREASE,
        DECREASE,
        RESET;

    }
}

