/*
 * Decompiled with CFR 0.152.
 */
package com.eng1.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.eng1.game.assets.images.ImageAssets;
import com.eng1.game.assets.skins.SkinAssets;
import com.eng1.game.screens.PlayScreen;
import com.eng1.game.screens.Screens;

public class CharacterScreen
extends ScreenAdapter {
    private final Stage stage;
    private final Table table = new Table();
    private final Skin uiSkin = SkinAssets.UI.get();

    public CharacterScreen() {
        this.stage = new Stage(new ScreenViewport());
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.stage);
        this.stage.addActor(this.table);
        this.table.setFillParent(true);
        this.table.setTransform(true);
        if (this.table.getChildren().isEmpty()) {
            this.setTableContents();
        }
        TableContents.CHARACTER1_BUTTON.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                PlayScreen.setSelectedCharacter(ImageAssets.PLAYER_CHARACTER_1);
                Screens.INSTRUCTION.setAsCurrent();
            }
        });
        TableContents.CHARACTER2_BUTTON.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                PlayScreen.setSelectedCharacter(ImageAssets.PLAYER_CHARACTER_2);
                Screens.INSTRUCTION.setAsCurrent();
            }
        });
        TableContents.CHARACTER3_BUTTON.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                PlayScreen.setSelectedCharacter(ImageAssets.PLAYER_CHARACTER_3);
                Screens.INSTRUCTION.setAsCurrent();
            }
        });
    }

    private void setTableContents() {
        this.table.pad(20.0f);
        this.table.defaults().pad(10.0f);
        this.table.add(TableContents.TITLE_LABEL).colspan(3).padBottom(40.0f);
        this.table.row();
        this.table.add(TableContents.CHARACTER1_BUTTON).fillX().uniformX().padRight(20.0f);
        this.table.add(TableContents.CHARACTER2_BUTTON).fillX().uniformX().padRight(20.0f);
        this.table.add(TableContents.CHARACTER3_BUTTON).fillX().uniformX();
        this.table.row().padTop(40.0f);
        Image character1Image = TableContents.CHARACTER1_IMAGE;
        this.table.add(character1Image).center().padRight(20.0f).width(character1Image.getWidth()).height(character1Image.getHeight());
        Image character2Image = TableContents.CHARACTER2_IMAGE;
        this.table.add(character2Image).center().padRight(20.0f).width(character2Image.getWidth()).height(character2Image.getHeight());
        Image character3Image = TableContents.CHARACTER3_IMAGE;
        this.table.add(character3Image).center().width(character3Image.getWidth()).height(character3Image.getHeight());
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.act(Math.min(Gdx.graphics.getDeltaTime(), 0.033333335f));
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void dispose() {
        this.stage.dispose();
        SkinAssets.UI.dispose(this.uiSkin);
        TableContents.dispose();
    }

    private static final class TableContents {
        private static final Skin UI_SKIN = SkinAssets.UI.get();
        public static final Label TITLE_LABEL = new Label((CharSequence)"I'd like to play as", UI_SKIN);
        public static final TextButton CHARACTER1_BUTTON = new TextButton("Liam", UI_SKIN);
        public static final TextButton CHARACTER2_BUTTON = new TextButton("Lucy", UI_SKIN);
        public static final TextButton CHARACTER3_BUTTON = new TextButton("Sammy", UI_SKIN);
        public static final Image CHARACTER1_IMAGE = new Image(ImageAssets.PLAYER_CHARACTER_1.get());
        public static final Image CHARACTER2_IMAGE = new Image(ImageAssets.PLAYER_CHARACTER_2.get());
        public static final Image CHARACTER3_IMAGE = new Image(ImageAssets.PLAYER_CHARACTER_3.get());
        final /* synthetic */ CharacterScreen this$0;

        public static void dispose() {
            SkinAssets.UI.dispose(UI_SKIN);
        }

        private TableContents(CharacterScreen characterScreen) {
            this.this$0 = characterScreen;
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }

        static {
            TITLE_LABEL.setFontScale(2.0f);
            CHARACTER1_BUTTON.getLabel().setFontScale(1.6f);
            CHARACTER2_BUTTON.getLabel().setFontScale(1.6f);
            CHARACTER3_BUTTON.getLabel().setFontScale(1.6f);
            float width = 400.0f;
            float height = 400.0f;
            CHARACTER1_IMAGE.setSize(400.0f, 400.0f);
            CHARACTER2_IMAGE.setSize(400.0f, 400.0f);
            CHARACTER3_IMAGE.setSize(400.0f, 400.0f);
        }
    }
}

