/*
 * Decompiled with CFR 0.152.
 */
package com.eng1.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.eng1.game.assets.skins.SkinAssets;
import com.eng1.game.game.Score;
import com.eng1.game.game.achievement.Achievements;
import com.eng1.game.screens.Screens;

public class EndScreen
implements Screen {
    private final Stage stage = new Stage(new ScreenViewport());
    private final Skin skin = SkinAssets.UI.get();
    private int scorePercentage;

    @Override
    public void show() {
        this.stage.clear();
        Gdx.input.setInputProcessor(this.stage);
        this.scorePercentage = Score.calculateScorePercentage();
        this.showGameOverScreen();
    }

    private void showGameOverScreen() {
        Achievements[] achievements;
        this.stage.clear();
        Table table = new Table();
        table.setFillParent(true);
        this.stage.addActor(table);
        Label gameOverLabel = new Label((CharSequence)("Game Over! You got " + this.scorePercentage + "% on your test!"), this.skin);
        gameOverLabel.setFontScale(1.5f);
        table.add(gameOverLabel).colspan(2);
        table.row().pad(10.0f, 0.0f, 0.0f, 10.0f);
        Label classificationLabel = new Label((CharSequence)("Classification: " + Score.getClassification(this.scorePercentage)), this.skin);
        classificationLabel.setFontScale(1.2f);
        table.add(classificationLabel).colspan(2);
        table.row().pad(10.0f, 0.0f, 0.0f, 10.0f);
        Label achievementLabel = new Label((CharSequence)"Achievements:", this.skin);
        achievementLabel.setFontScale(1.2f);
        table.add(achievementLabel).colspan(2);
        table.row().pad(10.0f, 0.0f, 0.0f, 10.0f);
        for (Achievements achievement : achievements = Achievements.values()) {
            if (!achievement.hasAchieved()) continue;
            Label label = new Label((CharSequence)(achievement.getName() + " - " + achievement.getDescription()), this.skin);
            label.setFontScale(1.0f);
            table.add(label).colspan(2);
            table.row().pad(5.0f, 0.0f, 0.0f, 10.0f);
        }
        TextButton continueButton = new TextButton("Continue", this.skin);
        continueButton.getLabel().setFontScale(1.2f);
        table.add(continueButton).colspan(2);
        continueButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (EndScreen.this.scorePercentage > Score.getLastScore()) {
                    Screens.HIGHSCORE.setAsCurrent();
                } else {
                    Screens.LEADERBOARD.setAsCurrent();
                }
            }
        });
        this.stage.setKeyboardFocus(continueButton);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.act(Math.min(Gdx.graphics.getDeltaTime(), 0.033333335f));
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.stage.dispose();
        this.skin.dispose();
    }
}

