/*
 * Decompiled with CFR 0.152.
 */
package com.eng1.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Dialog;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.eng1.game.assets.skins.SkinAssets;
import com.eng1.game.game.Score;
import com.eng1.game.screens.Screens;

public class HighScoreEntryScreen
implements Screen {
    private final Stage stage = new Stage(new ScreenViewport());
    private final Skin skin = SkinAssets.UI.get();
    private final int scorePercentage;

    public HighScoreEntryScreen(int scorePercentage) {
        this.scorePercentage = scorePercentage;
    }

    @Override
    public void show() {
        this.stage.clear();
        Gdx.input.setInputProcessor(this.stage);
        Table table = new Table();
        table.setFillParent(true);
        this.stage.addActor(table);
        Label highScoreLabel = new Label((CharSequence)"Congratulations! You got a high score!", this.skin);
        highScoreLabel.setFontScale(1.5f);
        table.add(highScoreLabel).colspan(2).padBottom(20.0f);
        table.row().pad(10.0f, 0.0f, 0.0f, 10.0f);
        Label nameLabel = new Label((CharSequence)"Enter your name:", this.skin);
        nameLabel.setFontScale(1.2f);
        table.add(nameLabel).colspan(2);
        table.row().pad(10.0f, 0.0f, 0.0f, 10.0f);
        final TextField nameField = new TextField("", this.skin);
        nameField.getStyle().font.getData().setScale(1.2f);
        table.add(nameField).colspan(2);
        table.row().pad(10.0f, 0.0f, 0.0f, 10.0f);
        TextButton submitButton = new TextButton("Save to leaderboard", this.skin);
        submitButton.getLabel().setFontScale(1.2f);
        table.add(submitButton).colspan(2);
        submitButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                String playerName = nameField.getText().trim().toLowerCase();
                if (playerName.isEmpty()) {
                    Dialog dialog = new Dialog("Error", HighScoreEntryScreen.this.skin, "dialog"){
                        {
                            this.text("Please enter your name.").pad(20.0f);
                            this.button("OK");
                        }
                    };
                    dialog.getContentTable().pad(10.0f);
                    dialog.show(HighScoreEntryScreen.this.stage);
                } else {
                    Score.saveScore(playerName, HighScoreEntryScreen.this.scorePercentage);
                    Screens.LEADERBOARD.setAsCurrent();
                }
            }
        });
        this.stage.setKeyboardFocus(submitButton);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.act(Math.min(Gdx.graphics.getDeltaTime(), 0.033333335f));
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.stage.dispose();
    }
}

