/*
 * Decompiled with CFR 0.152.
 */
package com.eng1.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.eng1.game.assets.images.ImageAssets;
import com.eng1.game.assets.skins.SkinAssets;
import com.eng1.game.screens.Screens;

public class InstructionScreen
extends ScreenAdapter {
    private final Stage stage;
    private final Skin uiSkin = SkinAssets.UI.get();
    private final Table table = new Table();
    private final Image mapOverview = new Image(ImageAssets.NEW_WORLD_MAP_OVERVIEW.get());
    private final ShapeRenderer shapeRenderer = new ShapeRenderer();

    public InstructionScreen() {
        this.stage = new Stage(new ScreenViewport());
        this.mapOverview.setPosition(-1000.0f, 0.0f);
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.stage);
        this.stage.addActor(this.table);
        this.table.setFillParent(true);
        this.table.setTransform(true);
        if (this.table.getChildren().isEmpty()) {
            this.setTableContents();
        }
        if (Gdx.input.isKeyJustPressed(66)) {
            Screens.MAIN.setAsCurrent();
        }
    }

    private void setTableContents() {
        this.table.setOrigin(1);
        this.table.setPosition(0.0f, 0.0f);
        float width = Gdx.graphics.getWidth();
        this.table.add(InstructionContents.TITLE).colspan(2).padBottom(20.0f).row();
        this.table.add(InstructionContents.INTRO).colspan(2).padBottom(20.0f).row();
        this.table.add(InstructionContents.INSTRUCTIONS).colspan(2).padBottom(20.0f).row();
        this.table.add(InstructionContents.START).colspan(2).padBottom(20.0f).row();
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        Gdx.gl.glActiveTexture(33984);
        Batch batch = this.stage.getBatch();
        batch.setProjectionMatrix(this.stage.getCamera().combined);
        batch.begin();
        this.mapOverview.draw(batch, 1.0f);
        batch.end();
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.setColor(0.0f, 0.0f, 0.0f, 0.5f);
        this.shapeRenderer.rect(0.0f, 0.0f, Gdx.graphics.getWidth() * 10, Gdx.graphics.getHeight() * 10);
        this.shapeRenderer.end();
        this.stage.draw();
        this.stage.act(Math.min(Gdx.graphics.getDeltaTime(), 0.033333335f));
        if (Gdx.input.isKeyJustPressed(66)) {
            Screens.MAIN.setAsCurrent();
        }
    }

    @Override
    public void resize(int width, int height) {
        Viewport viewport = this.stage.getViewport();
        viewport.update(width, height, true);
    }

    @Override
    public void dispose() {
        this.stage.dispose();
        SkinAssets.UI.dispose(this.uiSkin);
        TextureRegionDrawable drawable = (TextureRegionDrawable)this.mapOverview.getDrawable();
        ImageAssets.NEW_WORLD_MAP_OVERVIEW.dispose(drawable.getRegion().getTexture());
        this.shapeRenderer.dispose();
    }

    private static final class InstructionContents {
        private static final Skin UI_SKIN = SkinAssets.UI.get();
        private static final Label TITLE = new Label((CharSequence)"Welcome to Heslington Hustle!", UI_SKIN);
        private static final Label INTRO = new Label((CharSequence)"You wake up in your student accommodation.\nIt is Monday morning and you are still sleepy. It comes to your realisation that\nthis is your last week until exams begin! Trying not to panic, you think about today,\nand how to best manage your day with a healthy mix of studying, taking care of yourself and sleeping.\nYes, you do need sleep, even if you are hesitant to admit it!", UI_SKIN);
        private static final Label INSTRUCTIONS = new Label((CharSequence)"Welcome to the game!\n\nUse the following controls to navigate:\nW / \u2191 - Move Up\nA / \u2190 - Move Left\nS / \u2193 - Move Down\nD / \u2192 - Move Right\nPress ESC anytime to pause \n\n", UI_SKIN);
        private static final Label START = new Label((CharSequence)"Press Enter to start!", UI_SKIN);
        final /* synthetic */ InstructionScreen this$0;

        public static void dispose() {
            SkinAssets.UI.dispose(UI_SKIN);
        }

        private InstructionContents(InstructionScreen instructionScreen) {
            this.this$0 = instructionScreen;
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }

        static {
            TITLE.setFontScale(2.0f);
            INTRO.setFontScale(1.5f);
            INSTRUCTIONS.setFontScale(1.5f);
            START.setFontScale(1.5f);
            TITLE.setAlignment(1);
            INTRO.setAlignment(1);
            INSTRUCTIONS.setAlignment(1);
            START.setAlignment(1);
        }
    }
}

