/*
 * Decompiled with CFR 0.152.
 */
package com.eng1.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.eng1.game.assets.images.ImageAssets;
import com.eng1.game.assets.skins.SkinAssets;
import com.eng1.game.screens.Screens;

public class MenuScreen
extends ScreenAdapter {
    private final Stage stage;
    private final Skin uiSkin = SkinAssets.UI.get();
    private final Table table = new Table();
    private final Image mapOverview = new Image(ImageAssets.NEW_WORLD_MAP_OVERVIEW.get());
    private final ShapeRenderer shapeRenderer = new ShapeRenderer();

    public MenuScreen() {
        this.stage = new Stage(new ScreenViewport());
        this.mapOverview.setPosition(-1000.0f, 0.0f);
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.stage);
        this.stage.addActor(this.table);
        this.table.setFillParent(true);
        this.table.setTransform(true);
        if (this.table.getChildren().isEmpty()) {
            this.setTableContents();
        }
        TableContents.EXIT.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Gdx.app.exit();
            }
        });
        TableContents.NEW_GAME.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Screens.CHARACTER.setAsCurrent();
            }
        });
        TableContents.PREFERENCES.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Screens.PREFERENCES.setAsCurrent();
            }
        });
    }

    private void setTableContents() {
        this.table.setOrigin(1);
        this.table.setPosition(0.0f, 0.0f);
        float width = Gdx.graphics.getWidth();
        float widthPadding = width * 0.4f;
        float widthButton = TableContents.PREFERENCES.getWidth() * 4.0f;
        this.table.add(TableContents.TITLE).colspan(2);
        this.table.row().pad(10.0f, 0.0f, 0.0f, 0.0f);
        this.table.add(TableContents.NEW_GAME).fillX().uniformX().expandX().height(TableContents.NEW_GAME.getHeight() * 2.0f).width(widthButton).pad(10.0f, widthPadding, 10.0f, widthPadding);
        this.table.row().pad(10.0f, 0.0f, 10.0f, 0.0f);
        this.table.add(TableContents.PREFERENCES).fillX().uniformX().expandX().height(TableContents.PREFERENCES.getHeight() * 2.0f).width(widthButton).pad(10.0f, widthPadding, 10.0f, widthPadding);
        this.table.row();
        this.table.add(TableContents.EXIT).fillX().uniformX().expandX().height(TableContents.EXIT.getHeight() * 2.0f).width(widthButton).pad(10.0f, widthPadding, 10.0f, widthPadding);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        Gdx.gl.glActiveTexture(33984);
        Batch batch = this.stage.getBatch();
        batch.setProjectionMatrix(this.stage.getCamera().combined);
        batch.begin();
        this.mapOverview.draw(batch, 1.0f);
        batch.end();
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.setColor(0.0f, 0.0f, 0.0f, 0.5f);
        this.shapeRenderer.rect(0.0f, 0.0f, Gdx.graphics.getWidth() * 10, Gdx.graphics.getHeight() * 10);
        this.shapeRenderer.end();
        this.stage.draw();
        this.stage.act(Math.min(Gdx.graphics.getDeltaTime(), 0.033333335f));
    }

    @Override
    public void resize(int width, int height) {
        Viewport viewport = this.stage.getViewport();
        viewport.update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.stage.dispose();
        SkinAssets.UI.dispose(this.uiSkin);
        TextureRegionDrawable drawable = (TextureRegionDrawable)this.mapOverview.getDrawable();
        ImageAssets.NEW_WORLD_MAP_OVERVIEW.dispose(drawable.getRegion().getTexture());
        TableContents.dispose();
    }

    private static final class TableContents {
        private static final Skin UI_SKIN = SkinAssets.UI.get();
        public static final Image TITLE = new Image(ImageAssets.MAIN_MENU_TITLE.get());
        public static final TextButton NEW_GAME = new TextButton("New Game", UI_SKIN);
        public static final TextButton PREFERENCES = new TextButton("Preferences", UI_SKIN);
        public static final TextButton EXIT = new TextButton("Exit", UI_SKIN);
        final /* synthetic */ MenuScreen this$0;

        public static void dispose() {
            SkinAssets.UI.dispose(UI_SKIN);
        }

        private TableContents(MenuScreen menuScreen) {
            this.this$0 = menuScreen;
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }

        static {
            NEW_GAME.getLabel().setFontScale(1.6f);
            PREFERENCES.getLabel().setFontScale(1.6f);
            EXIT.getLabel().setFontScale(1.6f);
        }
    }
}

