/*
 * Decompiled with CFR 0.152.
 */
package com.eng1.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.maps.MapObjects;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.renderers.OrthogonalTiledMapRenderer;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.eng1.game.assets.images.ImageAssets;
import com.eng1.game.assets.maps.MapAssets;
import com.eng1.game.assets.skins.SkinAssets;
import com.eng1.game.game.player.Player;
import com.eng1.game.game.player.Statistics;
import com.eng1.game.utils.Pair;
import java.util.EnumMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayScreen
implements Screen {
    private static ImageAssets selectedCharacter = null;
    private static Texture selectedCharacterTexture = null;
    private OrthogonalTiledMapRenderer renderer;
    private MapAssets currentMapEnum = MapAssets.NEW_WORLD;
    private TiledMap currentMap = this.currentMapEnum.get();
    private OrthographicCamera camera = new OrthographicCamera();
    private Player player;
    private final BitmapFont displayDateTime = new BitmapFont();
    private final SpriteBatch uiBatch = new SpriteBatch();
    private final Skin uiSkin = SkinAssets.UI.get();
    private final EnumMap<MapAssets, Float> defaultViewportWidth = new EnumMap(MapAssets.class);
    private final EnumMap<MapAssets, Float> defaultViewportHeight = new EnumMap(MapAssets.class);
    private final EnumMap<MapAssets, Pair<Float, Float>> playerSizes = new EnumMap(MapAssets.class);
    private final EnumMap<MapAssets, Float> playerSpeeds = new EnumMap(MapAssets.class);

    public static void setSelectedCharacter(@NotNull ImageAssets character) {
        selectedCharacter = character;
        selectedCharacterTexture = selectedCharacter.get();
    }

    public void changeMap(@NotNull MapAssets map, @Nullable String transitionKey) {
        TiledMap copy = this.currentMap;
        MapAssets old = this.currentMapEnum;
        this.currentMapEnum = map;
        this.currentMap = this.currentMapEnum.get();
        this.playerSizes.computeIfAbsent(old, k -> Pair.of(Float.valueOf(this.player.getWidth()), Float.valueOf(this.player.getHeight())));
        this.playerSpeeds.computeIfAbsent(old, k -> Float.valueOf(this.player.getSpeed()));
        Pair<Float, Float> size = this.playerSizes.get(map);
        Float speed = this.playerSpeeds.get(map);
        this.renderer.setMap(this.currentMap);
        TiledMapTileLayer layer = (TiledMapTileLayer)this.currentMap.getLayers().get(0);
        float mapWidth = (float)layer.getWidth() * (float)layer.getTileWidth();
        float mapHeight = (float)layer.getHeight() * (float)layer.getTileHeight();
        float aspectRatio = (float)Gdx.graphics.getWidth() / (float)Gdx.graphics.getHeight();
        float mapAspectRatio = mapWidth / mapHeight;
        this.defaultViewportWidth.computeIfAbsent(old, k -> Float.valueOf(this.camera.viewportWidth));
        this.defaultViewportHeight.computeIfAbsent(old, k -> Float.valueOf(this.camera.viewportHeight));
        Float defaultViewWidth = this.defaultViewportWidth.get(map);
        if (defaultViewWidth != null) {
            this.camera.viewportWidth = defaultViewWidth.floatValue();
            this.camera.viewportHeight = this.defaultViewportHeight.get(map).floatValue();
        } else if (mapAspectRatio > aspectRatio) {
            this.camera.viewportHeight = mapHeight;
            this.camera.viewportWidth = mapHeight * aspectRatio;
        } else {
            this.camera.viewportWidth = mapWidth;
            this.camera.viewportHeight = mapWidth / aspectRatio;
        }
        float scaleX = this.camera.viewportWidth / this.defaultViewportWidth.get(old).floatValue();
        float scaleY = this.camera.viewportHeight / this.defaultViewportHeight.get(old).floatValue();
        if (size != null) {
            this.player.setSize(size.getLeft().floatValue(), size.getRight().floatValue());
        } else {
            this.player.setSize(this.player.getWidth() * scaleX, this.player.getHeight() * scaleY);
            this.playerSizes.put(map, Pair.of(Float.valueOf(this.player.getWidth()), Float.valueOf(this.player.getHeight())));
        }
        if (transitionKey == null) {
            this.setPlayerPosition();
        } else {
            this.setPlayerPosition(transitionKey);
        }
        if (speed != null) {
            this.player.setSpeed(speed.floatValue());
        } else {
            float scaleCombined = (scaleX + scaleY) / 2.0f;
            this.player.setSpeed(this.player.getSpeed() * scaleCombined);
            this.playerSpeeds.put(map, Float.valueOf(this.player.getSpeed()));
        }
        this.camera.zoom = 1.0f;
        this.camera.position.set(this.camera.viewportWidth / 2.0f, this.camera.viewportHeight / 2.0f, 0.0f);
        this.camera.update();
        this.renderer.getBatch().setProjectionMatrix(this.camera.combined);
        copy.dispose();
    }

    private void setPlayerPosition() {
        MapLayer layer = this.currentMap.getLayers().get("spawnpoint");
        boolean found = false;
        MapObjects objects = layer.getObjects();
        for (int i = 0; i < objects.getCount(); ++i) {
            MapObject mapObject = objects.get(i);
            if (!mapObject.getName().equals("spawnpoint")) continue;
            MapProperties properties = mapObject.getProperties();
            this.setPlayerPosition(((Float)properties.get("x")).floatValue(), ((Float)properties.get("y")).floatValue());
            found = true;
            break;
        }
        if (!found) {
            throw new RuntimeException("No spawnpoint found in map");
        }
    }

    private void setPlayerPosition(String transitionKey) {
        MapLayer layer = this.currentMap.getLayers().get("spawnpoints");
        boolean found = false;
        MapObjects objects = layer.getObjects();
        for (int i = 0; i < objects.getCount(); ++i) {
            MapObject mapObject = objects.get(i);
            if (!mapObject.getName().equals(transitionKey)) continue;
            MapProperties properties = mapObject.getProperties();
            this.setPlayerPosition(((Float)properties.get("x")).floatValue(), ((Float)properties.get("y")).floatValue());
            found = true;
            break;
        }
        if (!found) {
            this.setPlayerPosition();
        }
    }

    private void setPlayerPosition(float x, float y) {
        this.player = new Player(new Sprite(selectedCharacterTexture), (TiledMapTileLayer)this.currentMap.getLayers().get("collisions"), this.currentMap.getLayers().get("spawnpoints"), this.currentMap.getLayers().get("activities"));
        this.player.setPosition(x, y);
        Gdx.input.setInputProcessor(this.player);
    }

    @Override
    public void show() {
        this.camera = new OrthographicCamera();
        this.renderer = new OrthogonalTiledMapRenderer(this.currentMap);
        this.setPlayerPosition();
    }

    @Override
    public void render(float delta) {
        Gdx.gl20.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl20.glClear(16640);
        this.renderer.setView(this.camera);
        Batch batch = this.renderer.getBatch();
        batch.begin();
        boolean isNewWorld = this.currentMapEnum.equals(MapAssets.NEW_WORLD);
        List<String> topLayer = isNewWorld ? List.of("trees", "background") : List.of();
        for (int i = 0; i < this.currentMap.getLayers().getCount(); ++i) {
            MapLayer mapLayer = this.currentMap.getLayers().get(i);
            if (mapLayer == null || topLayer.contains(mapLayer.getName()) || !(mapLayer instanceof TiledMapTileLayer)) continue;
            this.renderer.renderTileLayer((TiledMapTileLayer)mapLayer);
        }
        this.camera.position.set(this.player.getX() + this.player.getWidth() / 2.0f, this.player.getY() + this.player.getHeight() / 2.0f, 0.0f);
        TiledMapTileLayer layer = (TiledMapTileLayer)this.currentMap.getLayers().get(0);
        float mapWidth = (float)layer.getWidth() * (float)layer.getTileWidth();
        float mapHeight = (float)layer.getHeight() * (float)layer.getTileHeight();
        this.camera.position.x = Math.min(mapWidth - this.camera.viewportWidth / 2.0f, Math.max(this.camera.viewportWidth / 2.0f, this.camera.position.x));
        this.camera.position.y = Math.min(mapHeight - this.camera.viewportHeight / 2.0f, Math.max(this.camera.viewportHeight / 2.0f, this.camera.position.y));
        this.camera.update();
        this.player.update(delta);
        this.player.draw(batch);
        for (String layerName : topLayer) {
            MapLayer mapLayer = this.currentMap.getLayers().get(layerName);
            if (mapLayer == null) continue;
            this.renderer.renderTileLayer((TiledMapTileLayer)mapLayer);
        }
        batch.end();
        this.uiBatch.begin();
        String stats = "Day: " + Statistics.getDay() + " - Time: " + Statistics.getTime().plusHours(1L);
        Label statsLabel = new Label((CharSequence)stats, this.uiSkin);
        statsLabel.setPosition((float)Gdx.graphics.getWidth() / 2.0f - statsLabel.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() - statsLabel.getHeight());
        statsLabel.draw(this.uiBatch, 1.0f);
        this.player.drawHud(this.uiBatch);
        this.uiBatch.end();
    }

    @Override
    public void resize(int width, int height) {
        this.camera.viewportWidth = width;
        this.camera.viewportHeight = height;
        this.camera.zoom = 1.0f;
        this.camera.position.set(this.camera.viewportWidth / 2.0f, this.camera.viewportHeight / 2.0f, 0.0f);
        this.camera.update();
        this.renderer.getBatch().setProjectionMatrix(this.camera.combined);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.currentMap.dispose();
        this.renderer.dispose();
        this.displayDateTime.dispose();
        selectedCharacter.dispose(selectedCharacterTexture);
        this.uiBatch.dispose();
        this.player.dispose();
        this.uiSkin.dispose();
    }
}

