/*
 * Decompiled with CFR 0.152.
 */
package com.eng1.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.eng1.game.assets.skins.SkinAssets;
import com.eng1.game.audio.music.MusicManager;
import com.eng1.game.screens.Screens;
import com.eng1.game.settings.Preferences;
import com.eng1.game.settings.SoundPreferences;

public class PreferencesScreen
implements Screen {
    private final Stage stage;
    private final Skin uiSkin = SkinAssets.UI.get();
    private final Table table = new Table();

    public PreferencesScreen() {
        this.stage = new Stage(new ScreenViewport());
    }

    private void setTableContents() {
        this.table.setOrigin(1);
        this.table.setPosition(0.0f, 0.0f);
        float itemWidth = TableContents.BACK_BUTTON.getWidth() * 8.0f;
        float itemHeight = TableContents.BACK_BUTTON.getHeight() * 2.0f;
        this.table.add(TableContents.TITLE_LABEL).colspan(2);
        this.table.row().pad(10.0f, 0.0f, 0.0f, 10.0f);
        this.table.add(TableContents.VOLUME_MUSIC_LABEL).left();
        this.table.add(TableContents.VOLUME_MUSIC_SLIDER).height(itemHeight).width(itemWidth).pad(10.0f, 15.0f, 10.0f, 0.0f);
        this.table.row().pad(10.0f, 0.0f, 0.0f, 10.0f);
        this.table.add(TableContents.MUSIC_TOGGLE_LABEL).left();
        this.table.add(TableContents.MUSIC_CHECKBOX).pad(10.0f, 0.0f, 10.0f, 0.0f);
        this.table.row().pad(10.0f, 0.0f, 0.0f, 10.0f);
        this.table.add(TableContents.BACK_BUTTON).colspan(2).height(itemHeight).width(itemWidth).pad(10.0f, 0.0f, 10.0f, 0.0f);
        this.table.row().pad(10.0f, 0.0f, 0.0f, 10.0f);
        this.table.add(TableContents.QUIT_BUTTON).colspan(2).height(itemHeight).width(itemWidth).pad(10.0f, 0.0f, 10.0f, 0.0f);
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.stage);
        this.stage.addActor(this.table);
        this.table.setFillParent(true);
        this.table.setTransform(true);
        if (this.table.getChildren().isEmpty()) {
            this.setTableContents();
        }
        Slider volumeMusicSlider = TableContents.VOLUME_MUSIC_SLIDER;
        volumeMusicSlider.addListener(event -> {
            SoundPreferences preference = Preferences.SOUND;
            preference.setVolume(volumeMusicSlider.getValue());
            MusicManager.getInstance().setVolume(volumeMusicSlider.getValue());
            return false;
        });
        Slider soundMusicSlider = TableContents.SOUND_MUSIC_SLIDER;
        soundMusicSlider.addListener(event -> {
            SoundPreferences preference = Preferences.SOUND;
            preference.setVolume(soundMusicSlider.getValue());
            return false;
        });
        CheckBox musicCheckbox = TableContents.MUSIC_CHECKBOX;
        musicCheckbox.addListener(event -> {
            boolean enabled = musicCheckbox.isChecked();
            if (enabled) {
                MusicManager.getInstance().onEnable();
            } else {
                MusicManager.getInstance().onDisable();
            }
            return false;
        });
        CheckBox soundEffectsCheckbox = TableContents.SOUND_EFFECTS_CHECKBOX;
        soundEffectsCheckbox.addListener(event -> {
            boolean enabled = soundEffectsCheckbox.isChecked();
            Preferences.SOUND.setEnabled(enabled);
            return false;
        });
        TableContents.BACK_BUTTON.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (Screens.MAIN.isLoaded()) {
                    Screens.MAIN.setAsCurrent();
                } else {
                    Screens.MENU.setAsCurrent();
                }
            }
        });
        TableContents.QUIT_BUTTON.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Gdx.app.exit();
            }
        });
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.act(Math.min(Gdx.graphics.getDeltaTime(), 0.033333335f));
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        TableContents.dispose();
        SkinAssets.UI.dispose(this.uiSkin);
        this.stage.dispose();
    }

    private static final class TableContents {
        private static final Skin UI_SKIN = SkinAssets.UI.get();
        public static final Slider VOLUME_MUSIC_SLIDER = new Slider(0.0f, 1.0f, 0.01f, false, UI_SKIN);
        public static final Slider SOUND_MUSIC_SLIDER = new Slider(0.0f, 1.0f, 0.01f, false, UI_SKIN);
        public static final CheckBox MUSIC_CHECKBOX = new CheckBox(null, UI_SKIN);
        public static final CheckBox SOUND_EFFECTS_CHECKBOX = new CheckBox(null, UI_SKIN);
        public static final TextButton BACK_BUTTON = new TextButton("Back", UI_SKIN);
        public static final TextButton QUIT_BUTTON = new TextButton("Quit", UI_SKIN);
        public static final Label TITLE_LABEL = new Label((CharSequence)"Preferences", UI_SKIN);
        public static final Label VOLUME_MUSIC_LABEL = new Label((CharSequence)"Music Volume", UI_SKIN);
        public static final Label VOLUME_SOUND_LABEL = new Label((CharSequence)"Sound Volume", UI_SKIN);
        public static final Label MUSIC_TOGGLE_LABEL = new Label((CharSequence)"Music", UI_SKIN);
        public static final Label SOUND_TOGGLE_LABEL = new Label((CharSequence)"Sound Effect", UI_SKIN);
        final /* synthetic */ PreferencesScreen this$0;

        public static void dispose() {
            SkinAssets.UI.dispose(UI_SKIN);
        }

        private TableContents(PreferencesScreen preferencesScreen) {
            this.this$0 = preferencesScreen;
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }

        static {
            VOLUME_MUSIC_SLIDER.setValue(Preferences.MUSIC.getVolume());
            SOUND_MUSIC_SLIDER.setValue(Preferences.SOUND.getVolume());
            MUSIC_CHECKBOX.setChecked(Preferences.MUSIC.isEnabled());
            SOUND_EFFECTS_CHECKBOX.setChecked(Preferences.SOUND.isEnabled());
            TITLE_LABEL.setFontScale(2.0f);
            BACK_BUTTON.getLabel().setFontScale(1.6f);
            QUIT_BUTTON.getLabel().setFontScale(1.6f);
            VOLUME_MUSIC_LABEL.setFontScale(1.6f);
            VOLUME_SOUND_LABEL.setFontScale(1.6f);
            MUSIC_TOGGLE_LABEL.setFontScale(1.6f);
            SOUND_TOGGLE_LABEL.setFontScale(1.6f);
            MUSIC_CHECKBOX.getImage().setScale(2.0f);
            SOUND_EFFECTS_CHECKBOX.getImage().setScale(2.0f);
        }
    }
}

