/*
 * Decompiled with CFR 0.152.
 */
package com.eng1.game.screens;

import com.badlogic.gdx.Screen;
import com.eng1.game.HeslingtonHustle;
import com.eng1.game.game.Score;
import com.eng1.game.screens.CharacterScreen;
import com.eng1.game.screens.EndScreen;
import com.eng1.game.screens.HighScoreEntryScreen;
import com.eng1.game.screens.InstructionScreen;
import com.eng1.game.screens.LeaderboardScreen;
import com.eng1.game.screens.LoadingScreen;
import com.eng1.game.screens.MainScreen;
import com.eng1.game.screens.MenuScreen;
import com.eng1.game.screens.PlayScreen;
import com.eng1.game.screens.PreferencesScreen;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Screens
extends Enum<Screens> {
    public static final /* enum */ Screens MENU = new Screens(MenuScreen::new);
    public static final /* enum */ Screens PREFERENCES = new Screens(PreferencesScreen::new);
    public static final /* enum */ Screens MAIN = new Screens(MainScreen::new);
    public static final /* enum */ Screens END = new Screens(EndScreen::new);
    public static final /* enum */ Screens HIGHSCORE = new Screens(() -> new HighScoreEntryScreen(Score.calculateScorePercentage()));
    public static final /* enum */ Screens LEADERBOARD = new Screens(LeaderboardScreen::new);
    public static final /* enum */ Screens CHARACTER = new Screens(CharacterScreen::new);
    public static final /* enum */ Screens LOADING = new Screens(LoadingScreen::new);
    public static final /* enum */ Screens PLAY = new Screens(PlayScreen::new);
    public static final /* enum */ Screens INSTRUCTION = new Screens(InstructionScreen::new);
    private static final HeslingtonHustle parent;
    private final Supplier<Screen> screenSupplier;
    @Nullable
    private Screen screen = null;
    private static final /* synthetic */ Screens[] $VALUES;

    public static Screens[] values() {
        return (Screens[])$VALUES.clone();
    }

    public static Screens valueOf(String name) {
        return Enum.valueOf(Screens.class, name);
    }

    private Screens(Supplier<Screen> screenSupplier) {
        this.screenSupplier = screenSupplier;
    }

    public boolean isLoaded() {
        return this.screen != null;
    }

    @NotNull
    public Screen get() {
        if (this.screen == null) {
            this.screen = this.screenSupplier.get();
        }
        return this.screen;
    }

    public void setAsCurrent() {
        parent.setScreen(this.get());
    }

    public boolean isCurrent() {
        return parent.getScreen().equals(this.get());
    }

    public static void disposeAll() {
        for (Screens screen : Screens.values()) {
            if (!screen.isLoaded()) continue;
            assert (screen.screen != null);
            screen.screen.dispose();
        }
    }

    private static /* synthetic */ Screens[] $values() {
        return new Screens[]{MENU, PREFERENCES, MAIN, END, HIGHSCORE, LEADERBOARD, CHARACTER, LOADING, PLAY, INSTRUCTION};
    }

    static {
        $VALUES = Screens.$values();
        parent = HeslingtonHustle.getInstance();
    }
}

